<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"/><xsl:import href="../../../../date.xsl"/><xsl:import href="../../../../table.xsl"/><xsl:import href="../../../../style.xsl"/><xsl:import href="../../../../lien.xsl"/><xsl:variable name="page-format" select="portrait"/><xsl:output encoding="UTF-8" method="xml" indent="yes"/><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"/><xsl:param name="nomenclaturePasEnrichie"/><xsl:variable name="nomenclature" select="document('../libellePlanCompte.xml')/n:Nomenclature"/><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"/><xsl:variable name="isPrint" select="1"/><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"/><xsl:template match="/dcfu:CompteFinancierUnique"/><xsl:template match="/dcfu:CompteFinancierUnique">
      <html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
         
         <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
            <meta name="generator" content="ODM"/>
            
            
            <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css"/>
            
            <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css"/>
            
            <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Calibri;
  panose-1:2 15 5 2 2 2 4 3 2 4;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoHeading8, li.MsoHeading8, div.MsoHeading8
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  page-break-after:avoid;
  font-size:12.0pt;
  font-family:"Times New Roman",serif;
  font-weight:bold;}
p.MsoHeader, li.MsoHeader, div.MsoHeader
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoFooter, li.MsoFooter, div.MsoFooter
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
span.Titre8Car
  {
  
  font-family:"Times New Roman",serif;
  font-weight:bold;}
span.En-tteCar
  {
  
  font-family:"Times New Roman",serif;}
span.PieddepageCar
  {
  
  font-family:"Times New Roman",serif;}
p.notedebasdepage, li.notedebasdepage, div.notedebasdepage
  {
  margin-top:0in;
  margin-right:46.5pt;
  margin-bottom:3.0pt;
  margin-left:0in;
  text-align:justify;
  font-size:6.0pt;
  font-family:"Arial",sans-serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:297mm 210mm;
  }
div.WordSection1
  {}
 /* List Definitions */
 ol
  {margin-bottom:0in;}
ul
  {margin-bottom:0in;}
--&gt;
/**/
}</style></head>
         
         
         
      <body lang="EN-US"><xsl:variable name="Refer1">A22RECFONC</xsl:variable><xsl:variable name="Refer2" select="$docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:IdColl/@V"/><xsl:variable name="Refer3" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V"/><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="concat ($Refer1, '_', $Refer2, '_', $Refer3)"/></xsl:call-template><div id="header">
               
               <p class="MsoHeader"><b><span style="font-size:8.0pt;font-family: &quot;Arial&quot;,&quot;sans-serif&quot;"><xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:LibelleColl/@V)"/> - <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:EnTeteBudget/n:LibelleEtab/@V)"/> - <xsl:value-of select="distinct-values($data/data:NatureDecision/data:valeur[@value = concat($docbudg//n:Budget/n:BlocBudget/n:NatDec/@V,                         if ($docbudg//n:Budget/n:BlocBudget/n:ProjetBudget/@V = 'true') then '-proj' else '')]/text())"/>  - <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V)"/></span></b></p>
               
            </div><div class="WordSection1">
               
               <div align="center">
                  
                  <xsl:variable name="varOdmTmpTab1">
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        <tr>
                           <td width="86.3%" valign="top" style="border-top:double 1.5pt; border-left:double 1.5pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&quot;Arial&quot;,sans-serif">II – EXECUTION BUDGETAIRE</span></b></p>
                              
                           </td>
                           <td width="13.7%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&quot;Arial&quot;,sans-serif">II</span></b></p>
                              
                           </td>
                        </tr>
                        <tr>
                           <td width="86.3%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:double black 1.5pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif">RECETTES DE FONCTIONNEMENT – VUE D’ENSEMBLE</span></b></p>
                              
                           </td>
                           <td width="13.7%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              <p class="MsoHeading8"><span lang="FR" style="font-size:10.0pt;font-family:&quot;Arial&quot;,sans-serif">A2.2</span></p>
                              
                           </td>
                        </tr>
                     </table>
                  </xsl:variable>
                  <xsl:call-template name="table:outputTable">
                     <xsl:with-param name="table" select="$varOdmTmpTab1"/>
                  </xsl:call-template>
                  
               </div>
               
               <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
               
               <div align="center">
                  
                  <xsl:variable name="varOdmTmpTab2">
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><xsl:variable name="varOdm1" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(./n:CodRD/@V='R') and (not(./n:Fonction/@V))                         and (./n:InfoOpe/@V='T') and (./n:OpBudg/@V='T')]"/>
                        <tr height="0" class="#tech# #fixWidths#">
                           <td width="5.4%" style="border:none" rowspan="1" colspan="1"/>
                           <td width="23.3%" style="border:none" rowspan="1" colspan="1"/>
                           <td width="10.7%" style="border:none" rowspan="1" colspan="1"/>
                           <td width="13.1%" style="border:none" rowspan="1" colspan="1"/>
                           <td width="13.1%" style="border:none" rowspan="1" colspan="1"/>
                           <td width="10.6%" style="border:none" rowspan="1" colspan="1"/>
                           <td width="10.3%" style="border:none" rowspan="1" colspan="1"/>
                           <td width="13.4%" style="border:none" rowspan="1" colspan="1"/>
                        </tr>
                        <tr style="height:.5in">
                           <td width="5.4%" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Chapitre</span></b></p>
                              
                           </td>
                           <td width="23.3%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Intitulé </span></b></p>
                              
                           </td>
                           <td width="10.7%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Prévisions (a) </span></b></p>
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:6.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">(BP + DM + RAR N-1)</span></b></p>
                              
                           </td>
                           <td width="13.1%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Réalisations</span></b></p>
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Titres émis (b) </span></b></p>
                              
                           </td>
                           <td width="13.1%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Rattachements (c) </span></b></p>
                              
                           </td>
                           <td width="10.6%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Total réalisations (d = b+c) </span></b></p>
                              
                           </td>
                           <td width="10.3%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Taux de réalisation (d/a)</span></b></p>
                              
                           </td>
                           <td width="13.4%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&quot;Arial&quot;,sans-serif">Restes à réaliser au 31/12 (1)</span></b></p>
                              
                           </td>
                        </tr>
                        <tr style="height:9.45pt"><xsl:variable name="varOdm2" select="$varOdm1[(n:ChapitreNature/@V='013')]"/>
                           <td width="5.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:9.45pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif">013</span></p>
                              
                           </td>
                           <td width="23.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '013' and @Type = 'C']/@LibelleCourt)[1])"/></span></p>
                           </td>
                           <td width="10.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm2/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm2/n:MtMdtTitreEmis/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm2/n:MtSup[(@Code='ProdChaRat')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="10.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm2/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="10.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm2/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr style="height:8.8pt"><xsl:variable name="varOdm3" select="$varOdm1[(n:ChapitreNature/@V='016')]"/>
                           <td width="5.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:8.8pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif">016</span></p>
                              
                           </td>
                           <td width="23.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '016' and @Type = 'C']/@LibelleCourt)[1])"/></span></p>
                           </td>
                           <td width="10.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm3/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm3/n:MtMdtTitreEmis/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm3/n:MtSup[(@Code='ProdChaRat')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="10.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm3/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="10.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm3/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr style="height:9.45pt"><xsl:variable name="varOdm4" select="$varOdm1[(n:ChapitreNature/@V='017')]"/>
                           <td width="5.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:9.45pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif">017</span></p>
                              
                           </td>
                           <td width="23.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '017' and @Type = 'C']/@LibelleCourt)[1])"/></span></p>
                           </td>
                           <td width="10.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm4/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm4/n:MtMdtTitreEmis/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm4/n:MtSup[(@Code='ProdChaRat')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="10.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm4/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="10.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm4/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr style="height:8.8pt"><xsl:variable name="varOdm5" select="$varOdm1[(n:ChapitreNature/@V='70')]"/>
                           <td width="5.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:8.8pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif">70</span></p>
                              
                           </td>
                           <td width="23.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '70' and @Type = 'C']/@LibelleCourt)[1])"/></span></p>
                           </td>
                           <td width="10.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm5/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm5/n:MtMdtTitreEmis/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm5/n:MtSup[(@Code='ProdChaRat')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="10.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm5/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="10.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm5/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr style="height:9.45pt"><xsl:variable name="varOdm6" select="$varOdm1[(n:ChapitreNature/@V='73')]"/>
                           <td width="5.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:9.45pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif">73</span></p>
                              
                           </td>
                           <td width="23.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '73' and @Type = 'C']/@LibelleCourt)[1])"/></span><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> (sauf 731)</span></p>
                           </td>
                           <td width="10.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm6/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm6/n:MtMdtTitreEmis/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm6/n:MtSup[(@Code='ProdChaRat')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="10.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm6/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="10.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm6/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr style="height:9.45pt"><xsl:variable name="varOdm7" select="$varOdm1[(n:ChapitreNature/@V='731')]"/>
                           <td width="5.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:9.45pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif">731</span></p>
                              
                           </td>
                           <td width="23.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '731' and @Type = 'C']/@LibelleCourt)[1])"/></span></p>
                           </td>
                           <td width="10.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm7/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm7/n:MtMdtTitreEmis/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm7/n:MtSup[(@Code='ProdChaRat')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="10.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm7/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="10.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm7/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr style="height:8.8pt"><xsl:variable name="varOdm8" select="$varOdm1[(n:ChapitreNature/@V='74')]"/>
                           <td width="5.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:8.8pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif">74</span></p>
                              
                           </td>
                           <td width="23.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '74' and @Type = 'C']/@LibelleCourt)[1])"/></span></p>
                           </td>
                           <td width="10.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm8/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm8/n:MtMdtTitreEmis/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm8/n:MtSup[(@Code='ProdChaRat')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="10.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm8/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="10.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm8/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr style="height:9.45pt"><xsl:variable name="varOdm9" select="$varOdm1[(n:ChapitreNature/@V='75')]"/>
                           <td width="5.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif">75</span></p>
                              
                           </td>
                           <td width="23.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '75' and @Type = 'C']/@LibelleCourt)[1])"/></span></p>
                           </td>
                           <td width="10.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm9/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm9/n:MtMdtTitreEmis/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm9/n:MtSup[(@Code='ProdChaRat')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="10.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm9/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="10.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm9/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr style="height:20.4pt">
                           <td width="28.8%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height: 20.4pt" rowspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Total des recettes de gestion des services</span></b></p>
                              
                           </td>
                           <td width="10.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:20.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECGESCOUFON')]/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:20.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECGESCOUFON')]/n:MtMdtTitreEmis/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:20.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECGESCOUFON')]/n:MtSup[(@Code='ProdChaRat')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="10.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:20.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> <xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECGESCOUFON')]/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="10.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:20.4pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:20.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECGESCOUFON')]/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <tr style="height:9.45pt"><xsl:variable name="varOdm10" select="$varOdm1[(n:ChapitreNature/@V='76')]"/>
                           <td width="5.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:9.45pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif">76</span></p>
                              
                           </td>
                           <td width="23.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '76' and @Type = 'C']/@LibelleCourt)[1])"/></span></p>
                           </td>
                           <td width="10.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm10/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm10/n:MtMdtTitreEmis/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm10/n:MtSup[(@Code='ProdChaRat')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="10.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm10/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="10.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm10/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr style="height:8.8pt"><xsl:variable name="varOdm11" select="$varOdm1[(n:ChapitreNature/@V='77')]"/>
                           <td width="5.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:8.8pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif">77</span></p>
                              
                           </td>
                           <td width="23.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '77' and @Type = 'C']/@LibelleCourt)[1])"/></span></p>
                           </td>
                           <td width="10.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm11/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm11/n:MtMdtTitreEmis/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm11/n:MtSup[(@Code='ProdChaRat')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="10.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm11/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="10.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm11/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr style="height:9.45pt"><xsl:variable name="varOdm12" select="$varOdm1[(n:ChapitreNature/@V='78')]"/>
                           <td width="5.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:9.45pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif">78</span></p>
                              
                           </td>
                           <td width="23.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify"><span style="font-size:8.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '78' and @Type = 'C']/@LibelleCourt)[1])"/></span><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> (semi-budgétaires)</span></p>
                           </td>
                           <td width="10.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm12/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm12/n:MtMdtTitreEmis/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm12/n:MtSup[(@Code='ProdChaRat')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="10.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm12/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                           <td width="10.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm12/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></p>
                           </td>
                        </tr>
                        <tr style="height:19.5pt">
                           <td width="28.8%" colspan="2" valign="top" style="border:solid black 1.0pt; border-left:double black 2.25pt;padding:0in 3.55pt 0in 3.55pt; height:19.5pt" rowspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Total des recettes réelles et mixtes</span></b></p>
                              
                           </td>
                           <td width="10.7%" valign="top" style="border:solid black 1.0pt; border-left:none;padding:0in 3.55pt 0in 3.55pt;height:19.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFONREL')]/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:solid black 1.0pt; border-left:none;padding:0in 3.55pt 0in 3.55pt;height:19.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFONREL')]/n:MtMdtTitreEmis/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:solid black 1.0pt; border-left:none;padding:0in 3.55pt 0in 3.55pt;height:19.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFONREL')]/n:MtSup[(@Code='ProdChaRat')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="10.6%" valign="top" style="border:solid black 1.0pt; border-left:none;padding:0in 3.55pt 0in 3.55pt;height:19.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFONREL')]/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="10.3%" valign="top" style="border:solid black 1.0pt; border-left:none;padding:0in 3.55pt 0in 3.55pt;height:19.5pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:solid black 1.0pt; border-left:none;padding:0in 3.55pt 0in 3.55pt;height:19.5pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFONREL')]/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <tr style="height:9.45pt"><xsl:variable name="varOdm13" select="$varOdm1[(n:ChapitreNature/@V='042')]"/>
                           <td width="5.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:9.45pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify"><i><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">042</span></i></p>
                              
                           </td>
                           <td width="23.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify"><i><span style="font-size:8.0pt; font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '042' and @Type = 'C']/@LibelleCourt)[1])"/></span></i><i><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"> (2)</span></i></p>
                           </td>
                           <td width="10.7%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm13/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></i></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm13/n:MtMdtTitreEmis/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></i></p>
                           </td>
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm13/n:MtSup[(@Code='ProdChaRat')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></i></p>
                           </td>
                           <td width="10.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm13/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></i></p>
                           </td>
                           <td width="10.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm13/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></i></p>
                           </td>
                        </tr>
                        <tr style="height:8.8pt"><xsl:variable name="varOdm14" select="$varOdm1[(n:ChapitreNature/@V='043')]"/>
                           <td width="5.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify"><i><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">043</span></i></p>
                              
                           </td>
                           <td width="23.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" style="text-align:justify"><i><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '043' and @Type = 'C']/@LibelleCourt)[1])"/></span></i></p>
                           </td>
                           <td width="10.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm14/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></i></p>
                           </td>
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm14/n:MtMdtTitreEmis/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></i></p>
                           </td>
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm14/n:MtSup[(@Code='ProdChaRat')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></i></p>
                           </td>
                           <td width="10.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm14/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></i></p>
                           </td>
                           <td width="10.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm14/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></i></p>
                           </td>
                        </tr>
                        <tr style="height:16.35pt">
                           <td width="28.8%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height: 16.35pt" rowspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Total des recettes d’ordre (3)</span></b></p>
                              
                           </td>
                           <td width="10.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:16.35pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFONORD')]/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:16.35pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFONORD')]/n:MtMdtTitreEmis/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:16.35pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFONORD')]/n:MtSup[(@Code='ProdChaRat')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="10.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:16.35pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFONORD')]/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="10.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:16.35pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:16.35pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFONORD')]/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <tr style="height:18.85pt">
                           <td width="28.8%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height: 18.85pt" rowspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Total des recettes de fonctionnement de l’exercice</span></b></p>
                              
                           </td>
                           <td width="10.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:18.85pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFON')]/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:18.85pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFON')]/n:MtMdtTitreEmis/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:18.85pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFON')]/n:MtSup[(@Code='ProdChaRat')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="10.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:18.85pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFON')]/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="10.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:18.85pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:18.85pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFON')]/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                        <tr style="height:16.4pt"><xsl:variable name="varOdm15" select="$varOdm1[(n:ChapitreNature/@V='002')]"/>
                           <td width="28.8%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height: 16.4pt" rowspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">002 Excédent de fonctionnement reporté de N-1</span></b></p>
                              
                           </td>
                           <td width="10.7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:16.4pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$varOdm15/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt;height:16.4pt" rowspan="1" colspan="1"> </td>
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt;height:16.4pt" rowspan="1" colspan="1"> </td>
                           <td width="10.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt;height:16.4pt" rowspan="1" colspan="1"> </td>
                           <td width="10.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt;height:16.4pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt;height:16.4pt" rowspan="1" colspan="1"> </td>
                        </tr>
                        <tr style="height:23.1pt">
                           <td width="28.8%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:double black 2.25pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height: 23.1pt" rowspan="1">
                              
                              <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Total des recettes de la section de fonctionnement</span></b></p>
                              
                           </td>
                           <td width="10.7%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:23.1pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECTOTFON')]/n:CredOuv/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:23.1pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECTOTFON')]/n:MtMdtTitreEmis/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:23.1pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECTOTFON')]/n:MtSup[(@Code='ProdChaRat')]/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="10.6%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:23.1pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECTOTFON')]/n:MtReal/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                           <td width="10.3%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:23.1pt" rowspan="1" colspan="1"> </td>
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:23.1pt" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECTOTFON')]/n:MtRAR3112/@V"/><xsl:with-param name="format" select="&quot;;unsec&quot;"/></xsl:call-template></span></b></p>
                           </td>
                        </tr>
                     </table>
                  </xsl:variable>
                  <xsl:call-template name="table:outputTable">
                     <xsl:with-param name="table" select="$varOdmTmpTab2"/>
                  </xsl:call-template>
                  
               </div>
               
               <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(1) Recettes justifiées non titrées.</span></p>
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(2) </span><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">Les comptes 78 peuvent figurer dans le détail du chapitre si la collectivité a opté pour le régime des provisions budgétaires,
                     conformément aux dispositions législatives et réglementaires applicables.</span></p>
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(3) <i>RF 042 = DI 040</i></span></p>
               
            </div></body></html>
   </xsl:template></xsl:stylesheet>